import viz
viz.go()

#LIVE_CHARACTER_SERVER = 'dev23'
LIVE_CHARACTER_SERVER = 'localhost'


##################################
# Setup character
##################################

#Add avatar
avatar = viz.add('vcc_male.cfg')

#Connect avatar to Live Character server
import vizmocap
#lc = vizmocap.LiveCharacter(LIVE_CHARACTER_SERVER,model=avatar)

#Connect to a Live Characters server at the specified address and port, attach the avatar
lc = vizmocap.LiveCharacter(LIVE_CHARACTER_SERVER,8050,8055,model=avatar)

#Set the window to stay on top
viz.window.setFloat()

##################################
# Setup origin markers
##################################

#Create tracker for controlling avatar origin
import viztracker
tracker = viztracker.Keyboard6DOF()
viz.link(tracker,avatar)

#Link marker to avatar node origin
node_origin = viz.add('node_origin.ive')
viz.link(tracker,node_origin)

#Link marker to avatar bone origin
bone_origin = viz.add('bone_origin.ive')
root_bone = avatar.getRootBoneList()[0]
bone_link = viz.link(root_bone,bone_origin)
bone_link.setPos([None,0,None]) #Clamp marker to ground level
bone_link.setEuler([None,0,0]) #Clamp pitch,roll to 0

#Create object group for origin markers
origin_markers = viz.ObjectGroup([bone_origin,node_origin])
origin_markers.visible(0)

##################################
# Setup environment
##################################

#Setup camera navigation
import vizcam
cam = vizcam.PivotNavigate(center=[0,2,0])
cam.rotateTo(0,4,10)
viz.cam.setHandler(cam)

#Set background color
viz.clearcolor(viz.GRAY)

#Create grid for ground plane
import vizshape
vizshape.addGrid(color=[0.2]*3)


##################################
# Setup animation blending
##################################
	
#Setup blending animation for avatar
avatar.state(4) #Play clap hands animation
BLEND_BONES = ['Bip01 L Clavicle','Bip01 R Clavicle'] #Bones to unlock for blending

def BlendAnimation(blend):
	'''Enable blending of pre-recorded animation'''
	if blend:
		for name in BLEND_BONES:
			avatar.getBone(name).unlock(True)
	else:
		for name in BLEND_BONES:
			avatar.getBone(name).lock(True)


##################################
# Setup hand attachments
##################################

#Create link for hand attachments
right_hand = avatar.getBone('Bip01 R Hand')
hand_attachments = viz.addGroup()
handLink = viz.link(right_hand,hand_attachments)
handLink.preEuler([-90,45,-90])
handLink.preTrans([0.07,0,0.03])

#Add hammer attachment
hammer = viz.add('warhammer.ive',parent=hand_attachments)
hammer.visible(0)

#Add saber attachment
saber = viz.add('saber.osg',parent=hand_attachments)
saber.hasparticles()
saber.visible(0)

#Add particle trail attachment
trail = viz.add('trail.osg',parent=hand_attachments)
trail.hasparticles()
trail.visible(0)

#Create list of attachment name/node pairs
attachments = [
			['None',None]
			,['Hammer',hammer]
			,['Saber',saber]
			,['Trail',trail]
			]

def SetAttachment(attachment):
	'''Set attachment index to use'''
	for name,node in attachments:
		if node:
			node.visible(0)
	if attachment:
		attachment.visible(1)


##################################
# Setup config dialog
##################################

#Add config dialog for options
import vizconfig
bc = vizconfig.BasicConfigurable('Character')
bc.addBoolItem('Display Origin',fset=origin_markers.visible)
bc.addBoolItem('Blend Animation',fset=BlendAnimation)
bc.addChoiceRadioItem('Hand Attachment',attachments,fset=SetAttachment)
vizconfig.register(bc)

